# Copyright (C) 2020  Braiins Systems s.r.o.
#
# This file is part of Braiins Open-Source Initiative (BOSI).
#
# BOSI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Please, keep in mind that we may also license BOSI or any part thereof
# under a proprietary license. For more information on the terms and conditions
# of such proprietary license or if you have any other questions, please
# contact us at opensource@braiins.com.

from setuptools import setup, find_packages

import bos_toolbox

requires = [
    'asyncssh==2.4.2',
    'base58==2.0.1',
    'paramiko==2.7.2',
    'progress==1.5',
    'requests==2.25.0',
]

setup(
    name='bos-toolbox',
    version=bos_toolbox.__version__,
    url='',
    license='GPL-3.0-or-later',
    author='Braiins',
    author_email='braiins@braiins.com',
    description='Braiins OS toolbox cli utility',
    packages=find_packages(),
    install_requires=requires,
    entry_points={'console_scripts': ['bos-toolbox=bos_toolbox.cli:main']},
)
