# Copyright (C) 2020  Braiins Systems s.r.o.
#
# This file is part of Braiins Open-Source Initiative (BOSI).
#
# BOSI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Please, keep in mind that we may also license BOSI or any part thereof
# under a proprietary license. For more information on the terms and conditions
# of such proprietary license or if you have any other questions, please
# contact us at opensource@braiins.com.

import os

from bos_toolbox.common import STAGE3_BUILTIN_SRC_DIR
from bos_toolbox.util import is_frozen


def _parse_package_version(package_name: str) -> str:
    exploded = package_name.split('_', maxsplit=2)[:2]
    return ' '.join(exploded)


def get_version_suffix() -> str:
    if not is_frozen():
        return ''

    packages_dir = os.path.join(STAGE3_BUILTIN_SRC_DIR, 'packages')
    if not os.path.isdir(packages_dir):
        return ''

    packages_version = ', '.join(
        _parse_package_version(name) for name in os.listdir(packages_dir)
    )
    return ' ({})'.format(packages_version)
