# Copyright (C) 2020  Braiins Systems s.r.o.
#
# This file is part of Braiins Open-Source Initiative (BOSI).
#
# BOSI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Please, keep in mind that we may also license BOSI or any part thereof
# under a proprietary license. For more information on the terms and conditions
# of such proprietary license or if you have any other questions, please
# contact us at opensource@braiins.com.

from enum import Enum


class Target(Enum):
    am1 = 1
    am2 = 2


class SubTarget(Enum):
    s9 = 1
    x17 = 2


class S9Variant(str, Enum):
    S9 = 'S9'

    def __str__(self):
        return self.value


class X17Variant(str, Enum):
    X17 = 'X17'
    S17 = 'S17'
    T17 = 'T17'
    S17_Pro = 'S17 Pro'
    S17_Plus = 'S17+'
    T17_Plus = 'T17+'
    S17_e = 'S17e'
    T17_e = 'T17e'

    def __str__(self):
        return self.value


class TargetTriple:
    def __init__(self, target: Target, sub_target: SubTarget, variant):
        self.target = target
        self.sub_target = sub_target
        self.variant = variant

    @property
    def target_full_name(self):
        return '{}-{}'.format(self.target.name, self.sub_target.name)


class OsType(Enum):
    BOS = 1
    stock = 2
    Vnish = 3
    ASICseer = 4


class OsMode(Enum):
    nand = 1
    sd = 2
    recovery = 3
    upgrade = 4


class OsInfo:
    def __init__(self, os_type: OsType, mode: OsMode, version):
        self.type = os_type
        self.mode = mode
        self.version = version
