# Copyright (C) 2020  Braiins Systems s.r.o.
#
# This file is part of Braiins Open-Source Initiative (BOSI).
#
# BOSI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Please, keep in mind that we may also license BOSI or any part thereof
# under a proprietary license. For more information on the terms and conditions
# of such proprietary license or if you have any other questions, please
# contact us at opensource@braiins.com.

from .descriptor import TargetTriple, OsInfo


class ProbeUnimplemented(Exception):
    pass


class PlatformStop(Exception):
    pass


class Probe:
    def __init__(self):
        pass

    def get_mac(self):
        raise ProbeUnimplemented

    def get_net_proto(self):
        raise ProbeUnimplemented

    def get_net_hostname(self):
        raise ProbeUnimplemented

    def get_net_ipaddr(self):
        raise ProbeUnimplemented

    def get_net_mask(self):
        raise ProbeUnimplemented

    def get_net_gateway(self):
        raise ProbeUnimplemented

    def get_net_dns(self):
        raise ProbeUnimplemented


class Platform:
    def __init__(self, triple: TargetTriple, os_info: OsInfo, probe: Probe):
        self.triple = triple
        self.os_info = os_info
        self.probe = probe
