# Copyright (C) 2020  Braiins Systems s.r.o.
#
# This file is part of Braiins Open-Source Initiative (BOSI).
#
# BOSI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Please, keep in mind that we may also license BOSI or any part thereof
# under a proprietary license. For more information on the terms and conditions
# of such proprietary license or if you have any other questions, please
# contact us at opensource@braiins.com.

from .antminer import PlatformAntminer
from .descriptor import Target, SubTarget, OsInfo
from .detect import Probe


class PlatformAm2(PlatformAntminer):
    FACTORY_MTDPARTS = 'mtdparts=pl35x-nand:40m(BOOT.bin-env-dts-kernel),32m(ramfs),8m(configs),16m(reserve),32m(ramfs-bak),128m(reserve1)'

    SYSTEM_BINARIES = [
        ('ld-musl-armhf.so.1', '/lib'),
        ('sftp-server', '/usr/lib/openssh'),
        ('fw_printenv', '/usr/sbin'),
        ('busybox1.25', '/bin'),
    ]

    SYSTEM_LINKS = [
        ('/usr/sbin/fw_setenv', '/usr/sbin/fw_printenv'),
        ('/usr/bin/awk', '/bin/busybox1.25'),
    ]

    def __init__(self, sub_target: SubTarget, variant, os_info: OsInfo, probe: Probe):
        super().__init__(Target.am2, sub_target, variant, os_info, probe)

    def get_default_factory_mtdparts(self):
        return self.FACTORY_MTDPARTS

    def get_system_binaries(self):
        return self.SYSTEM_BINARIES

    def get_system_links(self):
        return self.SYSTEM_LINKS
