# Copyright (C) 2020  Braiins Systems s.r.o.
#
# This file is part of Braiins Open-Source Initiative (BOSI).
#
# BOSI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Please, keep in mind that we may also license BOSI or any part thereof
# under a proprietary license. For more information on the terms and conditions
# of such proprietary license or if you have any other questions, please
# contact us at opensource@braiins.com.

import os

from .antminer import PlatformAntminer
from .descriptor import Target, SubTarget, S9Variant, OsInfo
from .detect import Probe


class PlatformAm1(PlatformAntminer):
    FACTORY_MTDPARTS = 'mtdparts=pl35x-nand:32m(BOOT.bin-env-dts-kernel),144m(angstram-rootfs),80m(upgrade-rootfs)'

    SYSTEM_BINARIES = [
        ('ld-musl-armhf.so.1', '/lib'),
        ('sftp-server', '/usr/lib/openssh'),
        ('fw_printenv', '/usr/sbin'),
    ]

    SYSTEM_LINKS = [('/usr/sbin/fw_setenv', '/usr/sbin/fw_printenv')]

    # Directory within the factory .tar.gz that contains all necessary firmware files.
    XILINX_DIR = 'xilinx'

    def __init__(self, os_info: OsInfo, probe: Probe):
        super().__init__(Target.am1, SubTarget.s9, S9Variant.S9, os_info, probe)

    def get_default_factory_mtdparts(self):
        return self.FACTORY_MTDPARTS

    def get_system_binaries(self):
        return self.SYSTEM_BINARIES

    def get_system_links(self):
        return self.SYSTEM_LINKS

    def get_firmware_path(self, firmware_dir):
        return os.path.join(firmware_dir, self.XILINX_DIR)
