# Copyright (C) 2020  Braiins Systems s.r.o.
#
# This file is part of Braiins Open-Source Initiative (BOSI).
#
# BOSI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Please, keep in mind that we may also license BOSI or any part thereof
# under a proprietary license. For more information on the terms and conditions
# of such proprietary license or if you have any other questions, please
# contact us at opensource@braiins.com.

import sys

from bos_toolbox.util import get_payload_path

if sys.platform.startswith('win32'):
    HOME_DIR = 'BOS Toolbox'
else:
    HOME_DIR = '.bos-toolbox'

BOS_URl = 'https://feeds.braiins-os.org'
BOS_PLUS_URl = 'https://feeds.braiins-os.com'
BOS_PLUS_NIGHTLY_URl = 'https://feeds-nightly.braiins-os.com'
BOS_REFERRAL_URL = 'https://referral.braiins-os.com'

BOS_REFERRAL_FEEDS_NAME = 'bos_referral'
BOS_REFERRAL_PKG_NAME = 'bos-referral'
BOS_CUSTOM_FEEDS_CFG = '/etc/opkg/custombosfeeds.conf'

BOS_FIRMWARE_PKG_NAME = 'firmware'

STAGE3_BUILTIN_SRC_DIR = get_payload_path('post-upgrade')


class ToolboxError(Exception):
    def __str__(self):
        return self.args[0]

    def context(self):
        return self.args[1:]
