# Copyright (C) 2020  Braiins Systems s.r.o.
#
# This file is part of Braiins Open-Source Initiative (BOSI).
#
# BOSI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Please, keep in mind that we may also license BOSI or any part thereof
# under a proprietary license. For more information on the terms and conditions
# of such proprietary license or if you have any other questions, please
# contact us at opensource@braiins.com.

import csv
import os

from .common import ToolboxError
from .util import is_valid_hostname


def _read_hosts_from_file(filepath) -> list:
    try:
        hosts = [
            row[0].strip()
            for row in csv.reader(open(filepath))
            if row and row[0].strip()
        ]
    except Exception as ex:
        raise ToolboxError(f"Invalid input file '{filepath}'", ex)
    # possibly skip csv header row
    if hosts and hosts[0] == 'host':
        hosts = hosts[1:]
    return hosts


def read_hosts(hosts) -> list:
    if os.path.isfile(hosts) or not is_valid_hostname(hosts):
        return _read_hosts_from_file(hosts)
    else:
        return [hosts]
